/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.admin.property.queue;

import filenet.vw.api.VWAttributeInfo;
import filenet.vw.api.VWFieldType;
import filenet.vw.api.VWWorkBasketDefinition;
import filenet.vw.base.VWDebug;

class VWWorkBasketAttributeRowItem {
    public static final int STATUS_NONE = 0;
    public static final int STATUS_NEW = 1;
    public static final int STATUS_MODIFIED = 2;
    protected static final String TRUE = "true";
    private String m_name = null;
    private int m_nType = 4;
    private boolean m_bIsArray = false;
    private Object m_value = this.getDefaultValue(this.m_nType, this.m_bIsArray);
    private int m_nStatus = 0;

    public VWWorkBasketAttributeRowItem() {
    }

    public VWWorkBasketAttributeRowItem(String name, int nType, boolean bIsArray, Object value, int nStatus) {
        this.m_name = name;
        this.m_nType = nType;
        this.m_bIsArray = bIsArray;
        this.m_value = value;
        this.m_nStatus = nStatus;
    }

    public String getName() {
        return this.m_name;
    }

    public void setName(String name, VWWorkBasketDefinition vwMapNode) {
        Object oldValue = this.m_value;
        this.m_value = null;
        this.updateAttributeInfo(vwMapNode, false);
        this.m_name = name;
        this.m_value = oldValue;
        this.updateAttributeInfo(vwMapNode, false);
    }

    public int getType() {
        return this.m_nType;
    }

    public String getTypeString() {
        try {
            String typeStr = VWFieldType.getLocalizedString(this.m_nType);
            if (this.m_bIsArray) {
                typeStr = typeStr + "[ ]";
            }
            return typeStr;
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            return null;
        }
    }

    public void setType(int nType, boolean bIsArray, VWWorkBasketDefinition workBasketDef) {
        this.m_nType = nType;
        this.m_bIsArray = bIsArray;
        this.m_value = this.getDefaultValue(this.m_nType, this.m_bIsArray);
        this.updateAttributeInfo(workBasketDef, false);
    }

    public boolean isArray() {
        return this.m_bIsArray;
    }

    public Object getValue() {
        return this.m_value;
    }

    public void setValue(Object value, VWWorkBasketDefinition workBasketDef) {
        this.m_value = value;
        this.updateAttributeInfo(workBasketDef, false);
    }

    public void remove(VWWorkBasketDefinition workBasketDef) {
        this.updateAttributeInfo(workBasketDef, true);
    }

    public boolean isModified() {
        return (this.m_nStatus & 2) > 0;
    }

    public boolean isNew() {
        return (this.m_nStatus & 1) > 0;
    }

    public String toString() {
        return this.m_name;
    }

    private Object getDefaultValue(int nType, boolean bIsArray) {
        try {
            if (bIsArray) {
                switch (nType) {
                    case 4: {
                        Boolean[] array = new Boolean[]{Boolean.TRUE};
                        return array;
                    }
                    case 8: {
                        Double[] array = new Double[]{0.0};
                        return array;
                    }
                    case 1: {
                        Integer[] array = new Integer[]{0};
                        return array;
                    }
                    case 2: {
                        String[] array = new String[]{""};
                        return array;
                    }
                }
            } else {
                switch (nType) {
                    case 4: {
                        return Boolean.TRUE;
                    }
                    case 8: {
                        return 0.0;
                    }
                    case 1: {
                        return 0;
                    }
                    case 2: {
                        return "";
                    }
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return null;
    }

    private void updateAttributeInfo(VWWorkBasketDefinition workBasketDef, boolean bDelete) {
        try {
            if (workBasketDef != null && this.m_name != null) {
                VWAttributeInfo attributeInfo = workBasketDef.getAttributeInfo();
                if (attributeInfo == null) {
                    attributeInfo = new VWAttributeInfo();
                } else if (attributeInfo.getFieldValue(this.m_name) != null) {
                    attributeInfo.deleteField(this.m_name);
                }
                if (!bDelete) {
                    attributeInfo.setFieldValue(this.m_name, this.m_value);
                }
                workBasketDef.setAttributeInfo(attributeInfo);
                this.m_nStatus |= 2;
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }
}

